#NoEnv
#SingleInstance Force
#Persistent

paused        := 0
data          := Object()
current_index := 0

^!n::
    if (data.MaxIndex() = "")
    {
        fullpath := A_ScriptDir "\DG.csv"
        
        if !FileExist(fullpath)
        {
            MsgBox, 16, Error, DG.csv not found in:`n%fullpath%
            return
        }

        data := Object()
        row  := 0

        Loop, Read, %fullpath%
        {
            line := Trim(A_LoopReadLine)
            if (line = "")
                continue

            parts := StrSplit(line, ",")
            if (parts.MaxIndex() < 1)
                continue

            row += 1
            num := Trim(parts[1])
            pal := (Trim(parts[2]) = "") ? 1 : Trim(parts[2])
            ps  := (Trim(parts[3]) = "") ? 1 : Trim(parts[3])
            typ := (parts.MaxIndex() >= 4) ? Trim(parts[4]) : ""

            ps := "PS" . (ps < 10 ? "0" . ps : ps)

            data[row]            := Object()
            data[row].num        := num
            data[row].ps         := ps
            data[row].pallet     := pal
            data[row].pallettype := typ
        }

        if (row = 0)
        {
            MsgBox, 48, Info, No deliveries found in DG.csv
            return
        }

        current_index := 0
        ToolTip Loaded %row% deliveries. Starting...
        SetTimer, RemoveToolTip, -2000
    }

    SetTimer, ProcessNextItem, -100
return

ProcessNextItem:
    SetTimer, ProcessNextItem, Off
    total := data.MaxIndex()

    if (current_index >= total)
    {
        ToolTip All %total% deliveries completed!
        SetTimer, RemoveToolTip, -3000
        return
    }

    current_index += 1
    item := data[current_index]

    current_num     := item.num
    current_ps      := item.ps
    current_pallet  := item.pallet
    palletType_str  := item.pallettype

    ; This line was causing the error — now fixed
    ToolTip Processing %current_num% (%current_index%/%total%)

    Gosub, Sequence
    SetTimer, ProcessNextItem, -800
return

Sequence:
    PauseCheck()
    PauseSleep(1000)

    CoordMode, Mouse, Screen
    Click, 117, 117
    SendInput, /NVL02
    PauseSleep(1000)
    SendInput, {Enter}
    PauseSleep(1000)

    SendInput, +{End}
    PauseSleep(500)
    SendInput, %current_num%
    PauseSleep(500)

    SendInput, {F8}
    PauseSleep(3000)
    SendInput, !{F12}
    PauseSleep(1000)

    SendInput, d
    PauseSleep(500)
    SendInput, u
    PauseSleep(1000)

    Click, 115, 478
    PauseSleep(500)
    SendInput, ZAU8

    Click, 27, 478
    PauseSleep(1000)

    SendInput, {F2}
    PauseSleep(1000)
    SendInput, SY05
    PauseSleep(500)
    SendInput, {Tab 2}{Space}
    PauseSleep(500)
    SendInput, {F3}
    PauseSleep(1000)

    Click, 27, 254
    PauseSleep(2000)

    SendInput, ^s
    PauseSleep(3000)
return

F7::
    paused := !paused
    ToolTip % paused ? "PAUSED" : "RUNNING"
    SetTimer, RemoveToolTip, -1500
return

RemoveToolTip:
    SetTimer, RemoveToolTip, Off
    ToolTip
return

PauseCheck() {
    global paused
    while (paused)
        Sleep, 100
}

PauseSleep(ms) {
    global paused
    start := A_TickCount
    while (A_TickCount - start < ms)
    {
        if (paused)
        {
            while (paused)
                Sleep, 100
            start := A_TickCount
        }
        Sleep, 50
    }
}